<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateBottomNavigationStyleRequest;
use App\Http\Requests\UpdateBottomNavigationStyleRequest;
use App\Models\BottomNavigationStyle;
use App\Repositories\BottomNavigationRepository;
use Illuminate\Http\Request;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;

class BottomNavigationStyleController extends AppBaseController
{
    /**
     * @var BottomNavigationRepository
     */
    private $bottomNavigationRepository;

    /**
     * @param BottomNavigationRepository $bottomNavigationRepository
     */
    public function __construct(BottomNavigationRepository $bottomNavigationRepository)
    {
        $this->bottomNavigationRepository = $bottomNavigationRepository;
    }

    /**
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('bottom_navigation_style.index');
    }

    public function store(CreateBottomNavigationStyleRequest $request)
    {
        $input = $request->all();
        $this->bottomNavigationRepository->create($input);

        return $this->sendSuccess(__('Bottom Navigation saved successfully.'));
    }

    /**
     * @param BottomNavigationStyle $bottomNavigationStyle
     *
     * @return JsonResponse
     */
    public function edit(BottomNavigationStyle $bottomNavigationStyle)
    {
        return $this->sendResponse($bottomNavigationStyle, __('Bottom Navigation retrieved '));
    }

    /**
     * @param BottomNavigationStyle $bottomNavigationStyle
     * @param UpdateBottomNavigationStyleRequest $request
     *
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     *
     * @return JsonResponse
     */
    public function update(BottomNavigationStyle $bottom_navigation_style, UpdateBottomNavigationStyleRequest $request)
    {
        $this->bottomNavigationRepository->update($request->all(), $bottom_navigation_style);

        return $this->sendSuccess(__('Bottom Navigation Updated Successfully.'));
    }

    /**
     * @param BottomNavigationStyle $bottomNavigationStyle
     * @return JsonResponse
     */
    public function destroy(BottomNavigationStyle $bottomNavigationStyle)
    {
        $bottomNavigationStyle->delete();

        return $this->sendSuccess(__('Bottom Navigation Deleted Successfully.'));
    }

    /**
     * @param Request $request
     *
     *
     * @return mixed
     */
    public function changeBottomNavStatus(Request $request)
    {
        $bottomNav = BottomNavigationStyle::findOrFail($request->id);
        $bottomNav->update(['status' => !$bottomNav->status]);

        return $this->sendResponse($bottomNav, 'Bottom Navigation Status Update Successfully');
    }

}
