<?php

namespace App\Http\Controllers;

use App\Models\ExitPopupConfiguration;
use App\Repositories\ExitPopupConfigurationRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class ExitPopupConfigurationController extends Controller
{


    /**
     * @var ExitPopupConfigurationRepository
     */
    private $exitPopupConfigurationRepo;

    /**
     * @param ExitPopupConfigurationRepository $ExitPopupConfigurationRepo
     */
    public function __construct(ExitPopupConfigurationRepository $ExitPopupConfigurationRepo)
    {
        $this->exitPopupConfigurationRepo = $ExitPopupConfigurationRepo;
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = ExitPopupConfiguration::pluck('value', 'key')->toArray();
        return view('exitpopup_configuration.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->exitPopupConfigurationRepo->store($request->all());

        Flash::success('Exits PopUp Updated successfully');

        return Redirect::back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
