<?php

namespace App\Models;

use App\Models\Contracts\JsonResourceful;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

/**
 * App\Models\WalkThrougu
 *
 * @property int $id
 * @property string $title
 * @property string|null $subtitle
 * @property int $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read string $walk_through_image
 * @property-read \Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection|Media[] $media
 * @property-read int|null $media_count
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough query()
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereSubtitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|WalkThrough whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class WalkThrough extends Model implements HasMedia, JsonResourceful
{
    use HasFactory, InteractsWithMedia;

    protected $table = 'walk_through';
    const WALK_THROUGH_IMAGE = 'walk_through_image';
    protected  $appends = ['walk_through_image'];
     protected $fillable = [
        'title',
        'subtitle',
        'status',
    ];
protected $casts = ['status' => 'boolean'];
    const ACTIVE = 1;
    const INACTIVE = 0;

    const STATUS = [
        self::ACTIVE    => 'Active',
        self::INACTIVE  => 'Inactive',
    ];

    public static $rules = [
        'title'              => 'required',
        'walk_through_image' => 'required',
    ];

    public function getWalkThroughImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::WALK_THROUGH_IMAGE)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }
        return asset('images/avatar.png');
    }

    public function prepareAttributes(): array
    {
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'subtitle'  => $this->subtitle,
        ];
    }
}
