<?php

namespace App\Repositories;


use App\Models\Product;

use App\Models\ShareContent;
use App\Models\ThemeStyle;
use App\Models\WalkThrough;

use Exception;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use function Psy\debug;


/**
 * Class AppConfigurationRepository
 */
class ThemeStyleRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return ShareContent::class;
    }

    public function store($input)
    {
        try {
            DB::beginTransaction();
            foreach ($input as $key => $value) {
                $themeStyleData = ThemeStyle::updateOrCreate(['key' => $key], ['value' => $value]);
            }
            DB::commit();

            return $themeStyleData;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
