<?php

use App\Models\AppConfiguration;
use App\Models\City;
use App\Models\Currency;
use App\Models\DoctorSession;
use App\Models\Notification;
use App\Models\PaymentGateway;
use App\Models\Setting;
use App\Models\State;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\HigherOrderBuilderProxy;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Stripe\Stripe;

/**
 *
 * @return Authenticatable|null
 */
function getLogInUser()
{
    return Auth::user();
}

/**
 * @return mixed
 */
function getAppName()
{
    static $setting;
    if (empty($setting)) {
        $setting = AppConfiguration::all()->keyBy('key');
    }

    return $setting['app_name']->value;

}

/**
 * @return mixed
 */
function getAppLogo()
{
    static $setting;
    if (empty($setting)) {
        $setting = AppConfiguration::all()->keyBy('key');
    }

    return $setting['app_logo']->value;
}

/**
 * @return mixed
 */
function getFloatingButtonLogo()
{
    static $setting;
    if (empty($setting)) {
        $setting = AppConfiguration::all()->keyBy('key');
    }

    return $setting['floating_buttton_logo']->value;
}

/**
 *
 * @return int
 */
function getLogInUserId()
{
    return Auth::user()->id;
}

/**
 * @return string
 */
function getDashboardURL()
{
    return RouteServiceProvider::HOME;
}

/**
 * @param $key
 *
 * @return mixed
 */
function getAppConfigValue($key)
{
    static $setting;

    if (empty($setting)) {
        $setting = AppConfiguration::all()->keyBy('key');
    }

    return $setting[$key]->value;
}

/**
 * @param $email
 * @return string
 */
function setEmailLowerCase($email)
{
    return strtolower($email);
}

function version()
{
    if(config('app.is_version') == 'true') {
        $composerFile = file_get_contents('../composer.json');
        $composerData = json_decode($composerFile, true);
        $currentVersion = $composerData['version'];

    return 'v'.$currentVersion;
    }
}
