@extends('layouts.app')
@section('title')
    App-Configuration
@endsection
@section('content')
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="card">
                <div class="card-body">
                    @include('flash::message')
                    @if ($errors->any())
                        <div class="alert alert-danger">{{ $errors->first() }}</div>
                    @endif
                    {{ Form::model($appConfigs,['route' => 'app.configuration.update', 'method' => 'post','id' => 'appConfigurationForm','files' => true]) }}
                        @csrf
                        <div class="row">
                            <div class="mb-5 form-group col-md-4">
                                <label for="appName" class="form-label">
                                    App Name:<span class="required"></span>
                                </label>
                                {{ Form::text('app_name', $appConfigs['app_name'], ['class' => 'form-control','placeholder'=>__('App Name'),'required']) }}
                            </div>
                            <div class="mb-5 form-group col-md-4">
                                <label for="appBaseURL" class="form-label">
                                    Base URL:<span class="required"></span>
                                </label>    
                                {{ Form::text('base_url', $appConfigs['base_url'], ['class' => 'form-control','placeholder'=>__('App Name'),'required']) }}
                            </div>
{{--                            <div class="mb-5 form-group col-md-4">--}}
{{--                                <label for="appLanguage" class="form-label">App Language</label>--}}
{{--                                {{ Form::select('app_language', $appLanguages, $appConfigs['app_language'], [--}}
{{--                                   'class' => 'form-select', 'aria-label'=>"Select a Currency",--}}
{{--                                   'data-control'=>'select2']) }}--}}
{{--                            </div>--}}
                            <div class="mb-5 form-group col-md-4">
                                <label for="appNavStyle" class="form-label">Navigation Style</label>
                                {{ Form::select('navigation_style', $navigationStyles, $appConfigs['navigation_style'], [
                                   'class' => 'form-select', 'id' => 'navStyle', 'aria-label'=>"Select a Currency",
                                   'data-control'=>'select2']) }}
                            </div>
                            <div class="mb-5 form-group col-md-8" io-image-input="true">
                                <label for="exampleInputImage" class="form-label">App Logo:</label>
                                <div class="d-block">
                                    <div class="image-picker">
                                        <div class="image previewImage" id="exampleInputImage"
                                             style="background-image: url('{{ isset($appConfigs['app_logo']) ?  url($appConfigs['app_logo']) :  asset('images/avatar.png') }}')"></div>
                                        <span class="picker-edit rounded-circle text-gray-500 fs-small" title="edit">
                                    <label>
                                    <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                        <input type="file" id="appLogo" name="app_logo"
                                               class="image-upload d-none" accept="image/*"/>
                                    </label>
                                </span>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 form-group col-md-4">
                                <label for="appLanguage" class="form-label">Header Style</label>
                                {{ Form::select('header_style', $headerStyles, $appConfigs['header_style'], [
                                  'class' => 'form-select', 'aria-label'=>"Select a Currency",
                                  'data-control'=>'select2']) }}
                            </div>
                            <div class="d-none" id="bottomNavStyle">
                                <h4 class="mb-2">Bottom Navigation style</h4>
                                <div class="d-md-flex justify-content-between mb-5 col-md-12">
                                    <div class="col-md-4 form-group d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="bottom_navigation" id="nav_0" value="1"
                                                   class="form-check-input" {{ ( $appConfigs['bottom_navigation'] == 1) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="nav_0">Bottom Navigation 1</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded button-navigation-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/bottom_navigation_1.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4 d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="bottom_navigation" id="nav_1" value="2"
                                                   class="form-check-input" {{ ( $appConfigs['bottom_navigation'] == 2) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="nav_1">Bottom Navigation 2</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded button-navigation-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/bottom_navigation_2.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="col-md-4 form-group d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="bottom_navigation" id="nav_2" value="3"
                                                   class="form-check-input" {{ ( $appConfigs['bottom_navigation'] == 3) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="nav_2">Bottom Navigation 3</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded button-navigation-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/bottom_navigation_3.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-none" id="tabStyle">
                                <h4 class="mb-2">Tab style</h4>
                                <div class="d-md-flex justify-content-between mb-5 col-md-12">
                                    <div class="col-md-4 form-group d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="tab_style" id="tab_style_1" value="1"
                                                   class="form-check-input" {{ ( $appConfigs['tab_style'] == 1) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="tab_style_1">Simple Tab-bar</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded table-style-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/simple_tab.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="form-group col-md-4 d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="tab_style" id="tab_style_2" value="2"
                                                   class="form-check-input" {{ ( $appConfigs['tab_style'] == 2) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="tab_style_2">Tab-bar with title and icon</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded table-style-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/tab_with_title_icon.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="col-md-4 form-group d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="tab_style" id="tab_style_3" value="3"
                                                   class="form-check-input" {{ ( $appConfigs['tab_style'] == 3) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="tab_style_3">Tab-bar with Icon</label>
                                        </div>
                                        <div class="mm-avatar p-1">
                                            <img class="img-fluid rounded  table-style-img border border-2 shadow"
                                                 src="{{ asset('images/app_configuration/tab_with_icon.png') }}"
                                                 alt="#" data-original-title="" title="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Disable Header</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="disable_header"
                                               id="disableHeader1" value="1" {{ ( $appConfigs['disable_header'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="disableHeader1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="disable_header"
                                               id="disableHeader2" value="0" {{ ( $appConfigs['disable_header'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="disableHeader2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Disable Footer</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="disable_footer"
                                               id="disableFooter1" value="1" {{ ( $appConfigs['disable_footer'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="disableFooter1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="disable_footer"
                                               id="disableFooter2" value="0" {{ ( $appConfigs['disable_footer'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="disableFooter2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Javascript Enable?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="javascript_enable"
                                               id="javascriptEnable1" value="1" {{ ( $appConfigs['javascript_enable'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="javascriptEnable1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="javascript_enable"
                                               id="javascriptEnable2" value="0" {{ ( $appConfigs['javascript_enable'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="javascriptEnable2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Required Splash Screen?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="required_flash_screen"
                                               id="requiredFlashScreen1" value="1" {{ ( $appConfigs['required_flash_screen'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredFlashScreen1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="required_flash_screen"
                                               id="requiredFlashScreen2"value="0" {{ ( $appConfigs['required_flash_screen'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredFlashScreen2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Is Support Zoom Functionality?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="is_support_zoom_functionality"
                                               id="isSupportZoomFunctionality1" value="1" {{ ( $appConfigs['is_support_zoom_functionality'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="isSupportZoomFunctionality1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="is_support_zoom_functionality"
                                               id="isSupportZoomFunctionality2" value="0" {{ ( $appConfigs['is_support_zoom_functionality'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="isSupportZoomFunctionality2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Required WalkThrough?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="required_walkthrough"
                                               id="requiredWalkThroughButtonYes" value="1" {{ ( $appConfigs['required_walkthrough'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredWalkThroughButtonNo">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="required_walkthrough"
                                               id="requiredWalkThroughButtonNo" value="0" {{ ( $appConfigs['required_walkthrough'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredWalkThroughButtonNo">No</label>
                                    </div>
                                </div>
                            </div>
{{--                            <div class="mb-5 col-md-4">--}}
{{--                                <h5 class="form-check-label">Is Support WebRTC Functionality?</h5>--}}
{{--                                <div class="form-group d-flex">--}}
{{--                                    <div class="form-check">--}}
{{--                                        <input class="form-check-input" type="radio" name="is_support_webrtc_functionality"--}}
{{--                                               id="isSupportWebRTCFunctionality1" value="1" {{ ( $appConfigs['is_support_webrtc_functionality'] == 1) ? 'checked' : '' }}>--}}
{{--                                        <label class="form-check-label" for="isSupportWebRTCFunctionality1">Yes</label>--}}
{{--                                    </div>--}}
{{--                                    <div class="form-check ms-3">--}}
{{--                                        <input class="form-check-input" type="radio" name="is_support_webrtc_functionality"--}}
{{--                                               id="isSupportWebRTCFunctionality2" value="0" {{ ( $appConfigs['is_support_webrtc_functionality'] == 0) ? 'checked' : '' }}>--}}
{{--                                        <label class="form-check-label" for="isSupportWebRTCFunctionality2">No</label>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Is Enable Pull to Refresh?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="is_enable_pull_to_refresh"
                                               id="isEnablePullToRefresh1" value="1" {{ ( $appConfigs['is_enable_pull_to_refresh'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="isEnablePullToRefresh1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="is_enable_pull_to_refresh"
                                               id="isEnablePullToRefresh2" value="0" {{ ( $appConfigs['is_enable_pull_to_refresh'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="isEnablePullToRefresh2">No</label>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Clear Cookies?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="clear_cookies"
                                               id="clearCookie1" value="1" {{ ( $appConfigs['clear_cookies'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="clearCookie1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="clear_cookies"
                                               id="clearCookie2" value="0" {{ ( $appConfigs['clear_cookies'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="clearCookie2">No</label>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Required Exit Popup Screen?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="required_exit_popup_screen"
                                               id="requiredExitPopupScreen1" value="1" {{ ( $appConfigs['required_exit_popup_screen'] == 1) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredExitPopupScreen1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="required_exit_popup_screen"
                                               id="requiredExitPopupScreen2" value="0" {{ ( $appConfigs['required_exit_popup_screen'] == 0) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="requiredExitPopupScreen2">No</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-12 walkthrough_style mb-4" id="walkthroughStyle">
                                <label for="walkthrough_style"> Walkthrough Style</label>
                                <div class="d-md-flex justify-content-between mt-4">
                                    <div class="col-md-4 d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="walkthrough_style" id="1" value="1" class="form-check-input" {{ ( $appConfigs['walkthrough_style'] == 1) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="walk_0">Walkthrough style 1</label>
                                        </div>
                                        <div class="mm-avatar p-2">
                                            <img class="border border-2 shadow img-fluid" src="{{ asset('images/app_configuration/walkthrough_style_1.png') }}" alt="walkthrough_style_1.png" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="col-md-4 d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="walkthrough_style" id="2" value="2" class="form-check-input" {{ ( $appConfigs['walkthrough_style'] == 2) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="walk_1">Walkthrough style 2</label>
                                        </div>
                                        <div class="mm-avatar p-2">
                                            <img class="border border-2 shadow img-fluid" src="{{ asset('images/app_configuration/walkthrough_style_2.png') }}" alt="walkthrough_style_2.png" data-original-title="" title="">
                                        </div>
                                    </div>
                                    <div class="col-md-4 d-inline">
                                        <div class="form-check">
                                            <input type="radio" name="walkthrough_style" id="3" value="3" class="form-check-input" {{ ( $appConfigs['walkthrough_style'] == 3) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="walk_2">Walkthrough style 3</label>
                                        </div>
                                        <div class="mm-avatar p-2">
                                            <img class="border border-2 shadow img-fluid" src="{{ asset('images/app_configuration/walkthrough_style_3.png') }}" alt="walkthrough_style_3.png" data-original-title="" title="">
                                        </div>
                                    </div>
                                </div>
                            </div>

{{--                            <div class="mb-5 col-md-4">--}}
{{--                                <h5 class="form-check-label">Required Floating Action Button?</h5>--}}
{{--                                <div class="form-group d-flex">--}}
{{--                                    <div class="form-check">--}}
{{--                                        <input class="form-check-input" type="radio" name="required_floating_action_button"--}}
{{--                                               id="requiredFloatingButtonYes" value="1" {{ ( $appConfigs['required_floating_action_button'] == 1) ? 'checked' : '' }}>--}}
{{--                                        <label class="form-check-label" for="requiredFloatingActionButton1">Yes</label>--}}
{{--                                    </div>--}}
{{--                                    <div class="form-check ms-3">--}}
{{--                                        <input class="form-check-input" type="radio" name="required_floating_action_button"--}}
{{--                                               id="requiredFloatingButtonNo" value="0" {{ ( $appConfigs['required_floating_action_button'] == 0) ? 'checked' : '' }}>--}}
{{--                                        <label class="form-check-label" for="requiredFloatingActionButton2">No</label>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}

{{--                            <div class="mb-5 form-group col-md-4" io-image-input="true" id="floatingLogo">--}}
{{--                                <label for="exampleInputImage" class="form-label">Floating Button Logo:</label>--}}
{{--                                <div class="d-block">--}}
{{--                                    <div class="image-picker">--}}
{{--                                        <div class="image previewImage" id="floatingButtonLogo"--}}
{{--                                             style="background-image: url('{{ isset($appConfigs['floating_buttton_logo']) ?  url($appConfigs['floating_buttton_logo']) :  asset('images/avatar.png') }}')"></div>--}}
{{--                                        <span class="picker-edit rounded-circle text-gray-500 fs-small" title="edit">--}}
{{--                                    <label>--}}
{{--                                    <i class="fa-solid fa-pen" id="floatingButtonLogo"></i>--}}
{{--                                        <input type="file" id="floatingButtonLogo" name="floating_buttton_logo"--}}
{{--                                               class="image-upload d-none" accept="image/*"/>--}}
{{--                                    </label>--}}
{{--                                </span>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}

{{--                            <div class="form-group col-md-4 floating_button" id="floatingStyle">--}}
{{--                                <label for="floating_button_style">Floating Button Style</label>--}}
{{--                                <div class="d-flex justify-content-between mt-4">--}}
{{--                                    <div class="col-md-4 d-inline">--}}
{{--                                        <div class="form-check col-md-2">--}}
{{--                                            <input type="radio" name="floating_button_style" id="0" value="1" checked="" class="form-check-input" {{ ( $appConfigs['floating_button_style'] == 1) ? 'checked' : '' }}>--}}
{{--                                            <label class="custom-control-label" for="radio_0">Regular</label>--}}
{{--                                        </div>--}}
{{--                                        <div class="mm-avatar col-md-2">--}}
{{--                                            <img class="avatar-100 rounded" src="{{ asset('images/app_configuration/regular.png') }}" alt="#">--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                    <div class="col-md-4 d-inline">--}}
{{--                                        <div class="form-check col-md-2">--}}
{{--                                            <input type="radio" name="floating_button_style" id="1" value="0" class="form-check-input" {{ ( $appConfigs['floating_button_style'] == 0) ? 'checked' : '' }}>--}}
{{--                                            <label class="custom-control-label" for="radio_1">Circular</label>--}}
{{--                                        </div>--}}
{{--                                        <div class="mm-avatar col-md-2">--}}
{{--                                            <img class="avatar-100 rounded" src="{{ asset('images/app_configuration/circular.png') }}" alt="#">--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
                            
                        <div class="float-end">
                            <button type="submit" class="btn btn-primary me-5">Save</button>
                            <button type="button" class="btn btn-secondary">Cancel</button>
                        </div>
                        </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
