@extends('layouts.app')
@section('title')
    {{ __('messages.user.edit_profile') }}
@endsection
@section('content')
    <div class="container-fluid">
        <div class="d-flex justify-content-between align-items-end mb-5">
            <h1>{{ __('messages.user.edit_profile') }}</h1>
        </div>

        <div class="col-12">
            @include('layouts.errors')
            @include('flash::message')
        </div>
        <div class="card">
            <div class="card-body">
                <form id="profileForm" method="POST" action="{{ route('update.profile.setting') }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row mb-5">
                        <div class="col-lg-4">
                            <label for="exampleInputImage" class="form-label">{{__('messages.common.profile')}}:</label>
                        </div>
                        <div class="col-lg-8">
                            @php $styleCss = 'style' @endphp
                            <div class="mb-3" io-image-input="true">
                                <div class="d-block">
                                    <div class="image-picker">
                                        <div class="image previewImage" id="exampleInputImage" {{ $styleCss }}="
                                        background-image: url('{{ $user->user_image }}')
                                        ">
                                    </div>
                                    <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                          data-bs-toggle="tooltip"
                                          data-bs-original-title="{{ __('messages.user.edit_profile') }}">
                                            <label> 
                                                <i class="fa-solid fa-pen" id="profileImageIcon"></i> 
                                                <input type="file" id="profilePicture" name="image"
                                                       class="image-upload d-none" accept="image/*"/> 
                                            </label> 
                                        </span>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>

            <div class="row mb-5">
                <label class="col-lg-4 form-label required">{{ __('messages.user.name').':' }}</label>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-lg-12">
                            {{ Form::text('name', $user->name, ['class'=> 'form-control', 'placeholder' => __('messages.user.name'), 'required']) }}
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-5">
                <label class="col-lg-4 form-label required">{{ __('messages.user.email').':' }}</label>
                <div class="col-lg-8">
                    {{ Form::email('email', $user->email, ['class'=> 'form-control', 'placeholder' => __('messages.user.email'), 'required']) }}
                </div>
            </div>

            <div class="row mb-5">
                <div class="d-flex py-6">
                    {{ Form::submit(__('messages.common.save'),['class' => 'btn btn-primary me-2']) }}
                </div>
            </div>
            </form>
        </div>
    </div>
    </div>
@endsection

