<?php

namespace App\Http\Controllers;

use App\Models\AboutAppConfiguration;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class AboutAppConfigurationController extends Controller
{
    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $aboutAppConfigurationData = AboutAppConfiguration::pluck('value', 'key')->toArray();
        return view('about_app_configuration.index', compact('aboutAppConfigurationData'));
    }

    /**
     * @param Request $request
     *
     *
     * @return RedirectResponse
     */
    public function update(Request $request)
    {
        $inputs = $request->all();
        foreach ($inputs as $key => $value) {
            $aboutAppData = AboutAppConfiguration::where('key', $key)->first();
            if (!$aboutAppData) {
                continue;
            }
            $aboutAppData->update(['value' => $value]);
        }

        Flash::success('About Ads Configuration Updated Successfully');
        return Redirect::back();
    }
}
