<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\AppBaseController;
use App\Models\AppConfiguration;

class ThemeStyleController extends AppBaseController
{
    public function index()
    {
        $color = [];
        $themeStyleData = AppConfiguration::pluck('value', 'key')->toArray();
        $color['gradient_enable'] = AppConfiguration::STATUS[$themeStyleData['gradient_enable']];
        if(isset( explode(', ',$themeStyleData['theme_style'])[1])){
            $color['theme_color_1'] =  explode(', ',$themeStyleData['theme_style'])[0];
            $color['theme_color_2'] =  explode(', ',$themeStyleData['theme_style'])[1];
        }else{
            $color['theme_color'] = $themeStyleData['theme_style'];
        }
        return $this->sendResponse($color, 'Theme Style fetch successfully');
    }
}
