<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateShareContentRequest;
use App\Models\ShareContent;
use App\Repositories\ShareContentRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class ShareContentController extends Controller
{

    /**
     * @param ShareContentRepository $shareContentRepo
     */
    public function __construct(ShareContentRepository $shareContentRepo)
    {
        $this->shareContentRepo = $shareContentRepo;
    }

    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $shareContentData = ShareContent::pluck('value', 'key')->toArray();
        return view('share_content.index', compact('shareContentData'));
    }

    /**
     * @param CreateShareContentRequest $request
     *
     *
     * @return RedirectResponse
     */
    public function store(CreateShareContentRequest $request)
    {
        $this->shareContentRepo->store($request->all());
        
        Flash::success('Share Content Saved successfully');
        
        return Redirect::back();
    }
}
