<?php

namespace App\Http\Controllers;


use App\Http\Requests\CreateWorkThroughRequest;
use App\Http\Requests\UpdateWorkThroughRequest;
use App\Models\WalkThrough;
use App\Repositories\WalkThroughRepository;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Laracasts\Flash\Flash;

class WalkThrouguController extends AppBaseController
{


    /**
     * @var WalkThroughRepository
     */
    private $walkThrouguRepo;

    /**
     * @param WalkThroughRepository $walkThrouguRepository
     */
    public function __construct(WalkThroughRepository $walkThrouguRepo)
    {
        $this->walkThrouguRepo = $walkThrouguRepo;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('walk_through.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    /**
     * @param CreateWorkThroughRequest $request
     *
     *
     * @return JsonResponse
     */
    public function store(CreateWorkThroughRequest $request)
    {
//        $walk = $this->walkThrouguRepo->store($request->all());

//        return $this->sendResponse($walk, 'Walk Through create successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function edit($id)
    {
        $walkThrough = WalkThrough::where('id', $id)->first();

        return $this->sendResponse($walkThrough, 'Walk Through successfully retrieved.');
    }


    /**
     * @param UpdateWorkThroughRequest $request
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function update(UpdateWorkThroughRequest $request, $id)
    {
        $input = $request->all();

        $service = $this->walkThrouguRepo->update($input, $id);


        return $this->sendResponse($service, 'Walk Through Update successfully.');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Walk = WalkThrough::whereId($id)->first();
//        $Walk->clearMediaCollection(WalkThrough::WALK_THROUGH_IMAGE);
        $Walk->delete();

        return $this->sendSuccess('Walk Through deleted successfully.');
    }

    /**
     * @param Request $request
     *
     *
     * @return JsonResponse
     */
    public function changeWalkThroughStatus(Request $request)
    {
  
        $Walk = WalkThrough::findOrFail($request->id);
        $Walk->update(['status' => !$Walk->status]);

        return $this->sendResponse($Walk, 'Walk Through Status Update Successfully');
    }
}
