<?php

namespace App\Http\Livewire;

use App\Models\FloatingButton;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\BottomNavigationStyle;

class FloatingButtonTable extends LivewireTableComponent
{
    protected $model = FloatingButton::class;
    
    public $showButtonOnHeader = true;
    public $buttonComponent = 'floating_button.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function resetPage($pageName = 'page')
    {
        $rowsPropertyData = $this->getRows()->toArray();
        $prevPageNum = $rowsPropertyData['current_page'] - 1;
        $prevPageNum = $prevPageNum > 0 ? $prevPageNum : 1;
        $pageNum = count($rowsPropertyData['data']) > 0 ? $rowsPropertyData['current_page'] : $prevPageNum;

        $this->setPage($pageNum, $pageName);
    }

    public function configure(): void
    {
        $this->setPrimaryKey('id')
            ->setDefaultSort('floating_buttons.created_at', 'desc')
            ->setQueryStringStatus(false);
    }

    public function columns(): array
    {
        return [
            Column::make("image", "id")
                ->view('floating_button.columns.floating_button_image'),
            Column::make("Title", "title")
                ->view('floating_button.columns.title')
                ->sortable(),
            Column::make("URL", "url")
                ->view('floating_button.columns.url')
                ->sortable(),
            Column::make(__('Status'), "status")
                ->view('floating_button.columns.status'),
            Column::make(__('Action'), "id")
                ->view('floating_button.action-button'),
        ];
    }
}
