<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class LeftHeaderNavigation extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $table = 'left_header_navigations';

    protected $fillable = [
        'title',
        'url',
        'status',
        'active',
    ];

    protected $with = ['media'];

    const IMAGE = 'left_header_image';

    public static $rules = [
        'title'   => 'required',
    ];

    const ACTIVE = 1;
    const INACTIVE = 0;

    const STATUS = [
        self::ACTIVE    => 'Active',
        self::INACTIVE  => 'Inactive',
    ];

//    const ACTIVE = 1;
//    const INACTIVE = 0;
//
//    const STATUS = [
//        self::ACTIVE    => 'Active',
//        self::INACTIVE  => 'Inactive',
//    ];
    public function getLeftHeaderImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::IMAGE)->first();
        if (! empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }
}
