<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class RightHeaderNavigation extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $table = 'right_header_navigations';

    protected $fillable = [
        'title',
        'url',
        'status',
        'active',
    ];

    protected $with = ['media'];

    const IMAGE = 'right_header_image';
    

    public function getRightHeaderImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::IMAGE)->first();
        if (! empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }
}
