<?php

namespace App\Repositories;

use App\Models\BottomNavigationStyle;
use Exception;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;

/**
 * Class BottomNavigationRepository
 */
class BottomNavigationRepository extends BaseRepository
{
    public $fieldSearchable = [
        'title',
        'url',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return BottomNavigationStyle::class;
    }
    
    /** @param  array  $input */
    public function create($input)
    {
        try {
            $input['status'] = isset($input['status']) ? 1 : 0;
            $bottomNavigation = BottomNavigationStyle::create($input);
           
            if (!empty($input['bottom_navigation_image'])) {
                $media = $bottomNavigation->addMedia($input['bottom_navigation_image'])->toMediaCollection(BottomNavigationStyle::IMAGE, config('app.media_disc'));
            }
            return true;
        } catch (Exception $e) {
            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }

    /**
     * @param  array  $input
     * @param  int  $userId
     *
     * @return void
     * @throws FileIsTooBig
     *
     * @throws FileDoesNotExist
     */
    public function update($input,$bottomNavigationStyle)
    {
        try {
            $input['status'] = isset($input['status']) ? 1 : 0;
            $bottomNavigationStyle->update($input);
            if (isset($input['bottom_navigation_image']) && !empty($input['bottom_navigation_image'])) {
                $bottomNavigationStyle->clearMediaCollection(BottomNavigationStyle::IMAGE);
                $bottomNavigationStyle->addMedia($input['bottom_navigation_image'])->toMediaCollection(BottomNavigationStyle::IMAGE,
                    config('app.media_disc'));
            }

        } catch (\Exception $e) {
            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
