<?php

namespace App\Repositories;


use App\Models\OneSignalConfiguration;
use Exception;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;


/**
 * Class AppConfigurationRepository
 */
class OneSignalConfigurationRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];
    
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }


    public function model()
    {
        return OneSignalConfiguration::class;
    }

    public function store($input)
    {
        try {
            DB::beginTransaction();
            
            foreach ($input as $key => $value)
            {
                $configurationData = OneSignalConfiguration::updateOrCreate(['key'  => $key],['value'  => $value]);
            }
            
            DB::commit();

            return $configurationData;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
