<?php

namespace App\Repositories;


use App\Models\Pages;
use App\Models\Product;

use App\Models\WalkThrough;

use Illuminate\Support\Facades\DB;


/**
 * Class AppConfigurationRepository
 */
class PagesRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return Pages::class;
    }

    /**
     * @param $input
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Eloquent\Model|void
     */
    
    public function store($input)
    {
        try {
            DB::beginTransaction();

            $input['status'] = isset($input['status']);
            $pages = Pages::create($input);

            if (isset($input['pages_image']) && !empty($input['pages_image'])) {
                $pages->addMedia($input['pages_image'])->toMediaCollection(Pages::PAGES_IMAGE,
                    config('app.media_disc'));
            }

            DB::commit();

            return $pages;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }

    public function update($input,$id)
    {
        try {
            DB::beginTransaction();
            $pages = Pages::findOrFail($id);
            $input['status'] = isset($input['status']);
            $pages->update($input);

            if (isset($input['pages_image']) && ! empty($input['pages_image'])) {
                $pages->clearMediaCollection(Pages::PAGES_IMAGE);
                $pages->addMedia($input['pages_image'])->toMediaCollection(Pages::PAGES_IMAGE,
                    config('app.media_disc'));
            }
           

            DB::commit();

            return $pages;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
