<?php

namespace App\Repositories;


use App\Models\Product;

use App\Models\UserAgent;
use App\Models\WalkThrough;

use Illuminate\Support\Facades\DB;


/**
 * Class AppConfigurationRepository
 */
class UserAgentRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return UserAgent::class;
    }

    /**
     * @param $input
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection|\Illuminate\Database\Eloquent\Model|void
     */
    
    public function store($input,$id)
    {
        try {
            DB::beginTransaction();
            
            $userAgent = UserAgent::create($input);
            
            DB::commit();

            return $userAgent;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }

    public function update($input,$id)
    {
        try {
            DB::beginTransaction();
            $userAgent = UserAgent::findOrFail($id);
            $userAgent->update($input);
            
            DB::commit();

            return $userAgent;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
