<?php

namespace Database\Seeders;

use App\Models\Doctor;
use App\Models\Patient;
use App\Models\Specialization;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DefaultUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = [
            [
                'name'              => 'Infy-web',
                'email'             => 'admin@infyweb.com',
                'email_verified_at' => Carbon::now(),
                'password'          => Hash::make('12345678'),
            ],
        ];
        foreach ($users as $key => $user) {
            $user = User::create($user);
        }
    }
}
