<?php

namespace App\Http\Controllers;

use App\Models\ProgressBar;
use App\Repositories\ProgressBarRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;

class ProgressBarController extends Controller
{
    /**
     * @var ProgressBarRepository
     */
    private $progressBarRepository;

    /**
     * @param ProgressBarRepository $progressBarRepository
     */
    public function __construct(ProgressBarRepository $progressBarRepository)
    {
        $this->progressBarRepository = $progressBarRepository;
    }

    /**
     * @return Application|Factory|View
     */
    public function index()
    {
        $progressBar = ProgressBar::pluck('value', 'key')->toArray();
        
        return view('progress_bar.index',compact('progressBar'));
    }


    /**
     * @param Request $request
     *
     * @throws FileDoesNotExist
     * @throws FileIsTooBig
     *
     * @return RedirectResponse
     */
    public function update(Request $request)
    {
        $id = 1;

        $this->progressBarRepository->update($request->all(), $id);

        Flash::success( __('Progress Bar updated successfully.'));

        return Redirect::back();
    }
}
