<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class ExitPopupConfiguration extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    const IMAGE = 'Image';
    protected $table = 'exit_popup_configuration';
    protected $appends = ['popup_image'];
    protected $with = ['media'];
    protected $fillable = [
        'key',
        'value',
    ];
    
    public function getPopupImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::IMAGE)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }
}
