<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class OneSignalConfiguration extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    const SIGNAL_IMAGE = 'signal_image';

    protected $table = 'one_signal_configurations';

    protected $appends = ['signal_image'];

    protected $fillable = [
        'key',
        'value',
    ];

    public function getSignalImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::SIGNAL_IMAGE)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }
}
