<?php

namespace Database\Seeders;

use App\Models\ExitPopupConfiguration;
use Illuminate\Database\Seeder;

class DefaultExitPopupSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $appLogoUrl = ('/images/avatar.png');

        $exitPopUpData = [
            'title'         => 'Do you want to exit at this moment ?',
            'positive_text' => 'Yes',
            'negative_text' => 'No',
            'enable_Image'  => 1,
            'Image'         => $appLogoUrl,
        ];
        foreach ($exitPopUpData as $key => $value) {
            $exitPopUpDataExist = ExitPopupConfiguration::where('key', $key)->exists();
            if (!$exitPopUpDataExist) {
                ExitPopupConfiguration::create(['key' => $key, 'value' => $value]);
            }
        }
    }
}
