document.addEventListener('turbo:load', loadThemeStyleData)

function loadThemeStyleData () {
    let gradientColor1 = $('#gradientColor1').val()
    let gradientColor2 = $('#gradientColor2').val()
    changeColor()
    if ($('#radioCustom').is(':checked')) {
        $('.custom_color_theme').removeClass('d-none')
    } else {
        $('.custom_color_theme').addClass('d-none')
    }
    if ($('#radioGradient').is(':checked')) {
        $('.gradient_color_theme').removeClass('d-none')
    } else {
        $('.gradient_color_theme').addClass('d-none')
    }

    if ($('input[name=\'gradient_enable\']:checked').val() == 0) {
        $('.gradientEnable').addClass('d-none');
    }else {
        $('.gradientDisable').addClass('d-none');
    }

    $('input[name=gradient_enable]').change(function () {
        let gradientIs = $(this).val()
        if (gradientIs == 0) {
            $('.gradientEnable').addClass('d-none')
            $('.gradientDisable').removeClass('d-none')
        } else {
            $('.gradientEnable').removeClass('d-none')
            $('.gradientDisable').addClass('d-none')
        }
    })
    
    listenChange('#gradientColor1', function () {
        gradientColor1 = $(this).val()
        changeColor()
    })
    listenChange('#gradientColor2', function () {
        gradientColor2 = $(this).val()
        changeColor()
    })

    listenClick('.custom', function () {
        $('.custom_color_theme').removeClass('d-none')
    })
    listenClick('.default_theme, .gradient', function () {
        $('.custom_color_theme').addClass('d-none')
    })
    listenClick('.gradient', function () {
        $('.gradient_color_theme').removeClass('d-none')
    })
    listenClick('.default_theme, .custom', function () {
        $('.gradient_color_theme').addClass('d-none')
    })

    listenChange('.customColor', function () {
        $('#radioCustom').val($(this).val())
    })

    listenChange('.gradientColor', function () {
        let color = []
        $('.gradientColor').each(function () {
            color.push($(this).val())
        })
        $('.gradient').val(color.join(', '))
    })

    function changeColor () {
        $('#previewGradient').
            css('background',
                'linear-gradient(to right bottom,' + gradientColor1 + ',' +
                gradientColor2 + ')')

    }
}
